<?php

namespace Drupal\stenographer;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\DependentPluginInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface for storing data for Stenographer recorders.
 */
interface StoreInterface extends PluginInspectionInterface, ConfigurableInterface, DependentPluginInterface {

  /**
   * Capture the logging data to the data store.
   *
   * @param array $data
   *   An array of data to capture into the logs.
   * @param \Drupal\stenographer\RecorderInterface $recorder
   *   The logger that the event is being written from.
   */
  public function write(array $data, RecorderInterface $recorder): void;

}
