<?php

namespace Drupal\stenographer\Trigger;

/**
 * Service / utility for consistent logging of entity events.
 */
class EntityTriggers implements TriggerBuilderInterface {

  /**
   * {@inheritdoc}
   */
  public function getTriggerType(): string {
    return 'entity';
  }

  /**
   * {@inheritdoc}
   */
  public function buildTriggers(array $recorders): array {
    $triggerMap = [];
    $triggerType = $this->getTriggerType();

    foreach ($recorders as $recorder) {
      $rid = $recorder->id();

      foreach ($recorder->getTriggers($triggerType) as $entityTypeId => $operations) {
        if (!empty($operations['operations'])) {
          $operations = $operations['operations'];
        }

        foreach ($operations as $op) {
          $triggerMap["{$entityTypeId}:{$op}"][$rid] = $rid;
        }
      }
    }

    return $triggerMap;
  }

}
