<?php

namespace Drupal\stenographer\Trigger;

/**
 * Helper function for modifying and attaching tracking events to exceptions.
 */
class ExceptionTriggers implements TriggerBuilderInterface {

  /**
   * {@inheritdoc}
   */
  public function getTriggerType(): string {
    return 'exception';
  }

  /**
   * {@inheritdoc}
   */
  public function buildTriggers(array $recorders): array {
    $type = $this->getTriggerType();

    $triggers = [];
    foreach ($recorders as $recorder) {
      $rid = $recorder->id();

      foreach ($recorder->getTriggers($type) as $exception => $label) {
        $triggers[$exception][$rid] = $rid;
      }
    }

    return $triggers;
  }

}
