CONTENTS OF THIS FILE
---------------------

 * Introduction
 * Requirements
 * Installation
 * Configuration
 * Extending
 * Maintainers


INTRODUCTION
------------

This module is for defining logging and tracking events which can be used to
capture activity on the system and send them to logging storage destinations.

The module is extendable and different triggers, data adapter and storage types
can all be added by providing the relevant plugins or strategy implementations.
See the section about [extending the module](#extending).

The module is named after the courtroom recorder who documents the court
proceedings and testimonies using a unique shortened writing style called
"steno" on a steno machine.


REQUIREMENTS
------------

This module requires the following modules:

 * [Toolshed](https://www.drupal.org/project/toolshed)


INSTALLATION
------------

Install as you would normally install a contributed Drupal module. Visit
https://www.drupal.org/node/1897420 for further information.


CONFIGURATION
-------------

The module uses `<module>.stenographer.yml` files to define recorder instances.
Recorders define triggers, the data to capture and where to send the event data.

This module includes an example stenographer definition file at
`example.stenographer.yml`. This file demonstrates some common `recorder` definitions that can be used to collect security activity and audit information
often used to detect suspicious user activity or provide breach notifications.
The included example file also provides comments that attempts to explain the variations parts of the definitions and some of the options.

Capture strategies, triggers, data adapters and storage plugins can all be added
to further add capabilities and options to the stenographer recorder. See the
section on [extending the module](#extending).

### Development

For local development environments the storage configuration can be overridden
for all the defined recorders. This allows developers to redirect all the
recorders to write to a different storage target.

This can be any valid storage configuration for a recorder, but for development
a useful configuration is to write all the log events to the `watchdog`. This
assumes that a watchdog log is enabled.

**settings.local.php**
```
$settings['stenographer.dev'] = [
  'storage' => 'drupal_watchdog',
];
```


EXTENDING
---------

### Capture Strategies

### Triggers

### Data Adapters

### Storage


MAINTAINERS
-----------

Current maintainers:
 * Liem Khuu (lemming) - https://www.drupal.org/u/lemming
