<?php

namespace Drupal\stenographer\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Attributes for the discovery of data adapter plugins for Stenographer.
 *
 * @see \Drupal\stenographer\DataAdapterInterface
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class StenographerAdapter extends Plugin {

  /**
   * Create a new instance of the Stenographer data adapter attribute.
   *
   * @param string $id
   *   The plugin identifier.
   * @param \Drupal\Component\Plugin\Context\ContextDefinitionInterface[] $contextDefinitions
   *   An array of context definitions expected by this plugin.
   * @param class-string|null $deriver
   *   The data adapter plugin deriver class to generate dynamic plugin
   *   definitions.
   */
  public function __construct(
    public readonly string $id,
    protected array $contextDefinitions = [],
    public readonly ?string $deriver = NULL,
  ) {}

}
