<?php

namespace Drupal\stenographer\Attribute;

use Drupal\toolshed\Strategy\Attribute\Strategy;

/**
 * Attribute for discovery of capture strategies.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class StenographerCapture extends Strategy {

  /**
   * Create a new attributes to mark capture strategy implementations.
   *
   * @param string $id
   *   The unique ID for the capture strategy.
   * @param bool $isPassThru
   *   Is this capture strategy implemented in the storage definitions? If so
   *   this event should always be sent and the destination is responsible for
   *   ensuring this capture frequency is respected.
   * @param class-string|null $deriver
   *   The strategy deriver if one is needed.
   */
  public function __construct(
    public readonly string $id,
    public readonly bool $isPassThru = FALSE,
    public readonly ?string $deriver = NULL,
  ) {}

}
