<?php

namespace Drupal\stenographer\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Attributes for the discovery of data condition plugins for Stenographer.
 *
 * Stenographer conditions will evaluate if the data included in an event meets
 * the configured condition. Is used by the recorder to determine if the event
 * log should be captured only if it meets data conditions.
 *
 * Because these conditions depend on the data, it only is executed after the
 * data adapters have generated the event properties. If your conditions do not
 * depend on the event data properties, consider using a capture strategy
 * instead, since these are evaluated every and can bypass the generation of
 * event data if it is not needed.
 *
 * @see \Drupal\stenographer\DataConditionInterface
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class StenographerCondition extends Plugin {

  /**
   * Create a new instance of the Stenographer data condition attribute.
   *
   * @param string $id
   *   The plugin identifier.
   * @param class-string|null $deriver
   *   The data condition plugin deriver class to generate dynamic plugin
   *   definitions.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?string $deriver = NULL,
  ) {}

}
