<?php

namespace Drupal\stenographer\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Attribute for the discovery of data storage plugins.
 *
 * @see \Drupal\stenographer\StoreInterface
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class StenographerStore extends Plugin {

  /**
   * Create a new instance of the Stenographer data storage plugin.
   *
   * @param string $id
   *   The plugin identifier for the data storage plugin.
   * @param class-string|null $deriver
   *   The data storage plugin deriver for creating dynamic plugin definitions.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?string $deriver = NULL,
  ) {}

}
