<?php

namespace Drupal\stenographer\Capture;

use Drupal\toolshed\Strategy\StrategyDefinitionBase;

/**
 * Capture strategy definition.
 */
class CaptureDefinition extends StrategyDefinitionBase {

  /**
   * Boolean to indicate if this definition is set as pass-thru.
   *
   * When the capture is set as pass-thru, it means that the event should always
   * capture, and pass the capture strategy to the storage destination and
   * should expect that it is handled there.
   *
   * @var bool
   */
  protected bool $passThru;

  /**
   * Creates a new instance of the StrategyDefinition class.
   *
   * @param string $id
   *   The strategy identifier.
   * @param mixed[] $definition
   *   The strategy definition found from the discovery.
   */
  public function __construct(string $id, array $definition) {
    parent::__construct($id, $definition);

    $this->passThru = $definition['isPassThru'] ?? TRUE;
  }

  /**
   * Return the event capture pass-thru flag.
   *
   * @return bool
   *   Is this capture set as a simple pass-thru capture.
   */
  public function isPassThru(): bool {
    return $this->passThru;
  }

}
