<?php

namespace Drupal\stenographer\Capture;

use Drupal\stenographer\Attribute\StenographerCapture;

/**
 * Only capture this same event once per time interval (specified in minutes).
 */
#[StenographerCapture(
  id: 'interval',
  isPassThru: TRUE,
)]
class IntervalCapture extends EventCapture {

  /**
   * {@inheritdoc}
   */
  public function formatStrategy(array $config = []): ?string {
    // Defaults to once every 60 minutes.
    $minutes = $config['interval'] ?? 60;
    return $this->definition->id() . ':' . $minutes;
  }

}
