<?php

namespace Drupal\stenographer\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Event class for altering the stenographer entity adapter class mapping.
 *
 * @see \Drupal\stenographer\Plugin\Derivative\EntityAdapterDeriver
 */
class EntityAdapterMapAlter extends Event {

  /**
   * Create a new instance of the EntityAdapterMapAlter class.
   *
   * @param class-string[] $adapterMap
   *   A reference to the entity type to adapter mapping.
   */
  public function __construct(protected array &$adapterMap) {
  }

  /**
   * Get the reference to the entity type to adapter mapping.
   *
   * Event listeners should alter this value to change or update the entity
   * type mapping as necessary.
   *
   * @return class-string[]
   *   List of entity types and which adapter class to use for that entity type.
   */
  public function &getAdapterMap(): array {
    return $this->adapterMap;
  }

}
