<?php

namespace Drupal\stenographer\Plugin\Stenographer\Adapter;

use Drupal\Core\Form\FormStateInterface;
use Drupal\stenographer\Attribute\StenographerAdapter;
use Drupal\stenographer\DataAdapterBase;
use Drupal\stenographer\DataAdapterInterface;

/**
 * Data provider that can provide values from a form state object.
 *
 * The form state can have mixed data, and therefore an accurate property
 * definitions are not available.
 */
#[StenographerAdapter('form_state')]
class FormStateAdapter extends DataAdapterBase implements DataAdapterInterface {

  /**
   * {@inheritdoc}
   */
  public function hasProperty(string $name, array $data): bool {
    $state = $data['form_state'] ?? NULL;
    return $state instanceof FormStateInterface
      ? $state->hasValue($name)
      : FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function get(string $name, array $data): mixed {
    $state = $data['form_state'] ?? NULL;
    return $state instanceof FormStateInterface
      ? $state->getValue($name)
      : NULL;
  }

}
