<?php

namespace Drupal\stenographer\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\stenographer\Attribute\StenographerStore;
use Drupal\stenographer\StoreInterface;

/**
 * Plugin manager for stenographer storage plugins.
 */
class StoragePluginManager extends DefaultPluginManager {

  /**
   * Creates a new instance of the StoragePluginManager class.
   *
   * @param \Traversable $namespaces
   *   The namespaces to search for storage plugin definitions.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cacheBackend
   *   The cache backend to store plugin definitions.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $moduleHandler
   *   The module extension handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cacheBackend, ModuleHandlerInterface $moduleHandler) {
    parent::__construct(
      'Plugin/Stenographer/Storage',
      $namespaces,
      $moduleHandler,
      StoreInterface::class,
      StenographerStore::class,
    );

    $this->setCacheBackend($cacheBackend, 'stenographer.storage');
    $this->alterInfo('stenographer_storage');
  }

}
