<?php

namespace Drupal\stenographer;

use Drupal\toolshed\Strategy\StrategyManagerInterface;

/**
 * Manager interface for Stenographer recorders.
 *
 * The manager for providing recorder definitions and instances.
 *
 * @method \Drupal\stenographer\RecorderInterface getInstance(string $id, array $contexts = [])
 */
interface RecorderManagerInterface extends StrategyManagerInterface {

  /**
   * Get all logger instances which are currently defined and loaded.
   *
   * @param string[]|null $ids
   *   Logger IDs to return. If NULL, then all loggers will be returned.
   *
   * @return \Drupal\stenographer\RecorderInterface[]
   *   Get all logger instances which are currently active.
   */
  public function getRecorders(?array $ids = NULL): array;

  /**
   * Get logger instances for the logger with a matching trigger.
   *
   * @param string $type
   *   The trigger type to match the triggers for.
   * @param string|null $trigger
   *   The trigger to match all the recorders to.
   *
   * @return array<string,string[]>|string[]
   *   List of recorder instances that match the requested trigger.
   */
  public function getByTrigger(string $type, ?string $trigger = NULL): array;

}
