<?php

namespace Drupal\stenographer;

/**
 * Kill switch for stenographer triggers.
 *
 * Allows disables triggering of stenograph recording events until the triggers
 * are switched back on. This status is maintained for a single request thread
 * and resets back to normal on reset.
 */
class StenographerKillSwitch {

  /**
   * Are recorder triggers halted?
   *
   * @var bool
   */
  protected bool $halted = FALSE;

  /**
   * Check to see if the triggers are halted.
   *
   * @return bool
   *   TRUE if event triggers are halted, FALSE otherwise.
   */
  public function isHalted(): bool {
    return $this->halted;
  }

  /**
   * Halt the running of triggering of stenographer events.
   *
   * @return self
   *   The object instance for method chaining.
   */
  public function halt(): self {
    $this->halted = TRUE;
    return $this;
  }

  /**
   * Resume the running of triggering of stenographer events.
   *
   * @return self
   *   The object instance for method chaining.
   */
  public function resume(): self {
    $this->halted = FALSE;
    return $this;
  }

}
