<?php

namespace Drupal\stenographer\Trigger;

/**
 * Helper function for modifying and attaching stenographer tracking to forms.
 */
class FormTriggers implements TriggerBuilderInterface {

  /**
   * {@inheritdoc}
   */
  public function getTriggerType(): string {
    return 'form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildTriggers(array $recorders): array {
    $triggerMap = [];
    $type = $this->getTriggerType();

    foreach ($recorders as $recorder) {
      $rid = $recorder->id();

      foreach ($recorder->getTriggers($type) as $formId => $trigger) {
        if (is_array($trigger) && $trigger['action']) {
          if (in_array($trigger['action'], ['validate', 'submit'])) {
            $triggerMap["{$formId}:{$trigger['action']}"][$rid] = $rid;
          }
        }
        else {
          $triggerMap["{$formId}:submit"][$rid] = $rid();
        }
      }
    }

    return $triggerMap;
  }

}
