# Sticky Audio Player

Provides a sticky audio player field formatter that displays a "Listen to Article" button. When clicked, a modern sticky audio player appears at the bottom of the screen, similar to Spotify's web player, allowing users to listen to audio content while browsing the page.

## Features

Sticky Audio Player adds a professional, user-friendly audio playback experience to your Drupal site. The module provides:

**Core Functionality:**
- Field formatter for entity reference fields targeting Media entities with audio files
- "Listen to Article" button that triggers the sticky player
- Modern, responsive sticky audio player that slides in from the bottom of the viewport
- Full playback controls including play/pause, seek bar, time display, speed control, and close button

**Unique Features:**
- **Sticky Player Interface**: The player remains visible at the bottom of the screen while users browse, similar to popular music streaming services
- **Navigation Persistence**: Optional feature to persist audio playback across page navigations using HTMX, allowing seamless listening while browsing the entire site
- **Automatic Sidebar Detection**: Intelligently adjusts position to account for admin theme sidebars (Gin, Claro, etc.) so controls are never hidden
- **Singleton Pattern**: Ensures only one audio instance plays at a time across the entire site
- **Keyboard Shortcuts**: Space bar for play/pause, arrow keys for seeking
- **Autoplay Option**: Configurable setting to automatically start playback when the button is clicked
- **Accessibility First**: Built with ARIA labels, keyboard navigation, and semantic HTML

**Use Cases:**
- News sites offering audio versions of articles
- Educational platforms with lecture recordings
- Podcast websites with episode playback
- Documentation sites with audio guides
- Any content type where audio enhances the reading experience

**When to Use:**
- You want to provide audio versions of text content
- You need a modern, non-intrusive audio player that doesn't interrupt the reading flow
- You want users to be able to listen while continuing to browse the page
- You need a player that works seamlessly with Drupal's Media system

## Post-Installation

After enabling the module, follow these steps to configure it:

1. **Navigate to Field Configuration**: Go to your content type's field settings (e.g., `/admin/structure/types/manage/article/fields`). Ensure you have an entity reference field that targets Media entities containing audio files.

2. **Configure Display Settings**: 
   - Go to Manage Display for your content type (e.g., `/admin/structure/types/manage/article/display`)
   - Find your audio field in the format list
   - Change the format dropdown to "Sticky Audio Player"
   - Click the gear icon (⚙️) next to the format to open configuration options

3. **Customize Settings**:
   - **Button text**: Set the text displayed on the button (default: "Listen to Article")
   - **Button icon**: Set an icon or emoji to display before the text (default: 🎧)
   - **Autoplay on button click**: Check this box if you want audio to start automatically when the button is clicked
   - **Navigation Persistence** (optional):
     - **Enable navigation persistence**: When enabled, the audio player will continue playing while users navigate between pages using AJAX navigation
     - **Content selector**: CSS selector for the main content area to swap (default: "main, .layout-content")
     - **Exclude selectors**: Comma-separated list of CSS selectors for links that should use normal navigation (e.g., external links, admin links)

4. **Save Configuration**: Click "Update" to save the formatter settings, then "Save" to save the display configuration.

5. **Test**: View a node that has the audio field. You should see the "Listen to Article" button. Clicking it will reveal the sticky audio player at the bottom of the screen.

**No Additional Configuration Pages Required**: The module works entirely through field formatter settings. There are no separate configuration pages to visit.

## Additional Requirements

**Drupal Core:**
- Drupal 10.3 or higher
- Drupal 11 or higher

**Core Modules (included with Drupal):**
- File module (enabled by default)
- Media module (enabled by default)
- HTMX library (included in Drupal core for navigation persistence feature)

**Field Setup:**
- An entity reference field on your content type
- The field must target Media entities
- Media entities must contain audio file fields (MP3, WAV, OGG, WebM formats supported)

**No External Libraries Required**: The module uses vanilla JavaScript and CSS, with no external dependencies.

## Recommended modules/libraries

While not required, these modules can enhance your audio content workflow:

- **Media Library** (core): Provides an improved interface for selecting and managing media items
- **Audio Field**: Alternative field type for direct audio file uploads if you prefer not to use Media entities
- **Transliteration**: Helps ensure audio filenames are URL-friendly

## Similar projects

Several modules provide audio playback functionality, but Sticky Audio Player offers unique advantages:

**Audio Field Module:**
- Provides basic HTML5 audio player embedded in content
- Sticky Audio Player differentiates by offering a sticky interface that doesn't interrupt reading flow
- Provides advanced controls (speed, seek, time display) and better UX

**Core Media Module:**
- Provides basic audio display through standard media formatters
- Sticky Audio Player adds a specialized, modern interface designed specifically for article/listening experiences
- Better integration with content workflows through the "Listen to Article" button pattern

**Key Differentiators:**
- Modern, sticky player interface similar to Spotify/YouTube
- **Navigation persistence**: Optional feature to continue playback across page navigations (unique among audio player modules)
- Automatic sidebar detection for admin themes
- Singleton pattern ensuring only one audio plays at a time
- Keyboard shortcuts and accessibility features
- Configurable autoplay option
- Non-intrusive design that enhances rather than interrupts content consumption

## Supporting this Module

This module is maintained by the Drupal community. Your support helps ensure continued development and improvement.

**Ways to Support:**
- Report bugs and feature requests in the [issue queue](https://www.drupal.org/project/issues/sticky_audio_player)
- Contribute code improvements via merge requests
- Help improve documentation
- Share your use cases and feedback

## Community Documentation

**Official Resources:**
- **Issue Queue**: [Report bugs, request features, or ask questions](https://www.drupal.org/project/issues/sticky_audio_player)
- **Module Documentation**: See inline code documentation and help text

**Getting Help:**
- Search existing issues before creating new ones
- Provide clear steps to reproduce bugs
- Include Drupal version, PHP version, and browser information when reporting issues

## Additional Information

### Browser Compatibility

The module uses standard Web Audio API and HTML5 audio elements, providing broad browser support:
- Chrome/Edge (latest versions)
- Firefox (latest versions)
- Safari (latest versions, including iOS)
- Mobile browsers (iOS Safari, Chrome Mobile)

### Performance Considerations

- The player JavaScript and CSS are loaded only when needed
- Audio files are streamed, so large files won't block page loading
- Singleton pattern ensures minimal resource usage
- No external API calls or third-party dependencies

### Accessibility

The module is built with accessibility in mind:
- Full keyboard navigation support (Space for play/pause, arrow keys for seeking)
- ARIA labels for screen readers
- Focus management for interactive elements
- Semantic HTML structure
- High contrast support

### Customization

The player's appearance can be customized through CSS. Key classes:
- `.sticky-audio-player` - Main player container
- `.listen-to-article-btn` - Button styling
- `.player-control` - Control buttons
- `.progress-bar` - Seek bar

Override these in your theme's CSS to match your site's design.

### Technical Details

- Uses vanilla JavaScript (no framework dependencies)
- Modern CSS with flexbox for responsive layout
- Drupal 10/11 Plugin API for field formatter
- Web Audio API for playback control
- Automatic sidebar width detection via JavaScript
- HTMX integration for seamless navigation persistence (optional)
- LocalStorage for state management across page navigations

### Navigation Persistence Feature

The navigation persistence feature allows the audio player to continue playing while users navigate between pages on your site. This is achieved using:

- **HTMX**: Drupal core's built-in HTMX library handles AJAX page navigation
- **State Management**: Player state (position, playing status, speed) is saved to localStorage
- **Seamless Experience**: Audio continues playing without interruption during navigation
- **Browser History**: Proper URL and history management for back/forward button support
- **Smart Exclusions**: Automatically excludes external links, admin links, and other special cases

**To Enable:**
1. Go to your field's display settings
2. Enable "Navigation Persistence" in the formatter configuration
3. Configure the content selector to match your theme's main content area
4. Optionally customize which links should be excluded from AJAX navigation

**Browser Compatibility:**
- Works in all modern browsers that support HTMX (Chrome, Firefox, Safari, Edge)
- Gracefully falls back to normal navigation if HTMX is unavailable
- State is preserved even on full page refreshes


