# Sticky Audio Player

Provides a sticky audio player field formatter that displays a "Listen to Article" button. When clicked, a modern sticky audio player appears at the bottom of the screen, similar to Spotify's web player, allowing users to listen to audio content while browsing the page.

## Features

- **Field Formatter**: Works with entity reference fields that target Media entities containing audio files (MP3, WAV, OGG, WebM)
- **Sticky Player UI**: Modern, responsive audio player that slides in from the bottom of the screen
- **Full Playback Controls**:
  - Play/Pause button
  - Seekable progress bar with click-to-seek functionality
  - Current time and duration display
  - Playback speed control (1x, 1.25x, 1.5x, 2x)
  - Close button to hide the player
- **Keyboard Support**: Space bar for play/pause, arrow keys for seeking
- **Autoplay Option**: Configurable setting to automatically start playback when the button is clicked
- **Admin Theme Compatible**: Automatically adjusts position to account for admin sidebars (Gin, Claro, etc.)
- **Singleton Pattern**: Only one audio instance plays at a time across the entire site
- **Accessible**: Built with ARIA labels and keyboard navigation support
- **Customizable**: Configurable button text and icon

## Post-Installation

1. **Enable the module** via Extend (`/admin/modules`) or Drush:
   ```
   drush en sticky_audio_player
   ```

2. **Configure a field**:
   - Navigate to your content type's field configuration (e.g., `/admin/structure/types/manage/article/fields`)
   - Ensure you have an entity reference field that targets Media entities
   - The Media entities should contain audio file fields

3. **Set the formatter**:
   - Go to Manage Display for your content type (e.g., `/admin/structure/types/manage/article/display`)
   - Find your audio field in the list
   - Change the format to "Sticky Audio Player"
   - Click the gear icon to configure:
     - **Button text**: Customize the text displayed on the button (default: "Listen to Article")
     - **Button icon**: Customize the icon/emoji before the text (default: 🎧)
     - **Autoplay on button click**: Enable to automatically start playback when clicked
   - Save the configuration

4. **View your content**: When viewing a node with the formatted field, you'll see the "Listen to Article" button. Clicking it will reveal the sticky audio player at the bottom of the screen.

## Additional Requirements

- **Drupal Core**: 10.3+ or 11+
- **Core Modules**: 
  - File module (included in core)
  - Media module (included in core)
- **Field Type**: Entity reference field targeting Media entities
- **Media Type**: Media entities must contain audio files (MP3, WAV, OGG, WebM formats supported)

## Recommended modules/libraries

- **Media Library**: Enhances media management and selection (included in core)
- **Audio Field**: Alternative field type for direct audio file uploads (if not using Media entities)

## Similar projects

- **Audio Field**: Provides a basic audio field formatter with a simple HTML5 audio player. Sticky Audio Player differentiates itself by:
  - Providing a modern, sticky player interface that stays visible while browsing
  - Offering advanced controls (speed, seek, time display)
  - Better integration with content workflows through the "Listen to Article" button pattern
  - Automatic sidebar detection for admin themes
  - Singleton pattern ensuring only one audio plays at a time

- **Media**: Core Media module provides basic audio display. Sticky Audio Player adds a specialized, user-friendly interface specifically designed for article/listening experiences.

## Supporting this Module

This module is maintained by the community. Contributions, bug reports, and feature requests are welcome on the [Drupal.org issue queue](https://www.drupal.org/project/issues/sticky_audio_player).

## Community Documentation

- **Issue Queue**: [Report bugs or request features](https://www.drupal.org/project/issues/sticky_audio_player)
- **Documentation**: See the module's help text and inline code documentation

## Additional Information

### Browser Compatibility

The module uses the Web Audio API and standard HTML5 audio elements, compatible with:
- Chrome/Edge (latest)
- Firefox (latest)
- Safari (latest)
- Mobile browsers (iOS Safari, Chrome Mobile)

### Performance

The player is loaded only when needed (when the button is clicked) and uses a singleton pattern to ensure minimal resource usage. Audio files are streamed, so large files won't block page loading.

### Accessibility

- Full keyboard navigation support
- ARIA labels for screen readers
- Focus management for interactive elements
- Semantic HTML structure

### Customization

The player's appearance can be customized through CSS. The main player container uses the class `.sticky-audio-player` and can be styled to match your theme.


