<?php

namespace Drupal\sticky_audio_player\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Sticky Audio Player settings for this site.
 */
class StickyAudioPlayerSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'sticky_audio_player_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['sticky_audio_player.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('sticky_audio_player.settings');

    $form['navigation_persistence'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Navigation Persistence'),
      '#description' => $this->t('Allow the audio player to continue playing while users navigate between pages.'),
    ];

    $form['navigation_persistence']['enable_navigation_persistence'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable navigation persistence'),
      '#default_value' => $config->get('enable_navigation_persistence'),
      '#description' => $this->t('When enabled, the audio player will persist across page navigations using AJAX, allowing seamless playback while browsing.'),
    ];

    $form['navigation_persistence']['content_selector'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Content selector'),
      '#default_value' => $config->get('content_selector'),
      '#description' => $this->t('CSS selector for the main content area to swap during navigation (e.g., "main, .layout-content").'),
      '#states' => [
        'visible' => [
          ':input[name="enable_navigation_persistence"]' => ['checked' => TRUE],
        ],
      ],
    ];

    $form['navigation_persistence']['exclude_selectors'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Exclude selectors'),
      '#default_value' => $config->get('exclude_selectors'),
      '#description' => $this->t('Comma-separated list of CSS selectors for links that should NOT use AJAX navigation (e.g., external links, admin links).'),
      '#states' => [
        'visible' => [
          ':input[name="enable_navigation_persistence"]' => ['checked' => TRUE],
        ],
      ],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('sticky_audio_player.settings')
      ->set('enable_navigation_persistence', $form_state->getValue('enable_navigation_persistence'))
      ->set('content_selector', $form_state->getValue('content_selector'))
      ->set('exclude_selectors', $form_state->getValue('exclude_selectors'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}

