## Sticky Local Tasks

There are times when you are on a long page and you have to scroll up to the top
of the page to access the local tasks (also known as primary tabs) such as
_View_, _Edit_, etc. This module provides a sticky icon on the bottom right of
the page that holds all the local task items for easier access. Icons are from
icons8 and under glyph-neue category.

## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules].

[Installing Drupal Modules]:https://www.drupal.org/docs/extending-drupal/installing-drupal-modules

## Upgrading

After upgrading from 1.x to 2.x you have to execute the database update and check
your setting on `/admin/config/user-interface/sticky-local-tasks`.

If you get this error, please execute database update or clear container
cache (e.g. `drush cc container`):
```
TypeError: Drupal\Core\Theme\Registry::Drupal\Core\Theme\{closure}(): Argument #1 ($callable) must be of type callable, string given
```

## Configuration

There are three ways you can add sticky local tasks to pages:
1. Configure the module to add them to pages regardless of theme, optionally
   filtering out admin routes.
   1. Go to `admin/config/user-interface/sticky-local-tasks`.
   2. Select _Add sticky primary tabs to all pages on all themes_.
   3. If you want them to show up on admin routes, check _Show on admin pages_.
   4. Set the desired position.
   5. Save the configuration.
2. Place and configure the _Sticky primary tabs_ block.
   1. Go to `admin/config/user-interface/sticky-local-tasks`.
   2. Select _Use Sticky primary tabs block or custom code_.
   3. Save the configuration.
   4. Go to `admin/structure/block`.
   5. Optionally choose the theme you want the sticky tasks to show up in.
   6. Choose a region and click _Place block_. The region only affects the
      position of the tabs in the markup, not where they visually appear.
   7. Configure the block: select the visual position for the sticky tabs and
      any other configuration you'd like, eg. show the block only on certain
      pages or for certain roles.
   8. Save the configuration.
3. Add the links directly in a template or preprocess.
   1. Go to `admin/config/user-interface/sticky-local-tasks`.
   2. Select the usage option for _custom code_.
   3. Save the configuration.
   4. The following code returns the render array:
      ```php
      $position = \Drupal\sticky_local_tasks\Position::BottomLeft;
      $build = \Drupal::service('sticky_local_tasks.builder')->build($position);
      ```

## Hide default local tasks

Per default the option to hide default local tasks is enabled. The selector for
hiding the block is `.block-local-tasks-block`. If your theme uses other class names
you have to add this class or add own CSS to your theme.
See `assets/css/hide_default_local_tasks.css`.

## Altering Sticky Local Task Tabs

This module provides a hook to allow other modules to set icons for custom
routes and for the routes provided by other contributed modules.

### Implementing the Hook

In your module:

```php
function your_module_sticky_local_tasks_route_alter(array &$route_to_link_name_map) {
  $route_to_link_name_map['your_module.my_custom_tab'] = 'custom-tab';
}
```

### CSS changes

In your custom CSS:

```css
.sticky-local-tasks__wrapper .nav-item--custom-tab .nav-link__icon {
  background-image: url('icon--custom-tab.svg');
}
```

## Theme Integration

The module includes optional integration with the Gin admin theme and manual dark mode support.

### Gin Theme Colors

When the "Use Gin theme colors" option is enabled, the sticky local tasks will use Gin's color variables to match the admin theme's appearance.

### Manual Dark Theme

The "Use dark theme" option allows you to force dark mode colors regardless of your system preference. This works with both Gin integration and the default color palette.

### Configuration

1. Go to `admin/config/user-interface/sticky-local-tasks`.
2. Under the usage options, you'll find two checkboxes:
   - **Use Gin theme colors**: Enable Gin theme integration
   - **Use dark theme**: Force dark mode colors
3. Save the configuration.

### Theme Behavior

- **Gin colors disabled + Dark theme disabled**: Uses original 2.x light colors
- **Gin colors disabled + Dark theme enabled**: Uses module's dark color palette
- **Gin colors enabled + Dark theme disabled**: Follows system dark/light mode with Gin colors
- **Gin colors enabled + Dark theme enabled**: Forces Gin dark colors regardless of system preference

**Note:** Both settings are disabled by default to maintain the original module appearance.

## Change colors / CSS

The module delivers CSS for light and dark modes. The colors are stored in CSS custom properties (variables). You can override them like this:

```css
.sticky-local-tasks__wrapper {
  --background: #your-background-color;
  --background2: #your-secondary-background;
  --background3: #your-tertiary-background;
  --background-hover: #your-hover-color;
  --text-color: #your-text-color;
  --svg-fill-color: #your-icon-color;
}
```

When Gin theme integration is enabled, these variables will be overridden with Gin's color palette:

```css
.sticky-local-tasks__wrapper {
  --background: var(--gin-bg-layer, var(--default-background));
  --background2: var(--gin-bg-layer2, var(--default-background2));
  --background3: var(--gin-bg-layer3, var(--default-background3));
  --background-hover: var(--gin-bg-layer3, var(--default-background-hover));
  --text-color: var(--gin-color-title, var(--default-text-color));
  --svg-fill-color: var(--gin-color-primary, var(--default-svg-fill-color));
}
```

## Maintainers

Sohail Lajevardi: https://www.drupal.org/u/doxigo
