'use·strict';

/**
 * Drupal JS.
 */
((Drupal, once) => {
  Drupal.behaviors.stickyLocalTasks = {
    attach(context) {
      const [toggle] = once(
        'sticky-local-tasks',
        '[data-sticky-local-tasks-toggle]',
        context,
      );
      if (!toggle) {
        return;
      }

      const items = context.querySelector('[data-sticky-local-tasks-items]');

      // Show the sticky local tasks items
      const showStickyLocalTasksItems = () => {
        items.style.display = 'flex';
        items.classList.add('show');
      };

      // Hide the sticky local tasks items
      const hideStickyLocalTasksItems = (animated = true) => {
        // @todo If it's just the case that we want display none when the
        //   animation/transition finishes, can we not do that entirely with
        //   CSS?
        if (animated) {
          setTimeout(() => {
            items.style.display = 'none';
          }, 200);
          items.classList.remove('show');
        } else {
          items.classList.remove('show');
          items.style.display = 'none';
        }
      };

      // Read saved state
      const rememberToggledState =
        drupalSettings?.stickyLocalTasks?.rememberToggledState;
      const savedState =
        rememberToggledState &&
        localStorage.getItem('Drupal.sticky_local_tasks.shown');

      // Tidy up toggle state if function is disabled.
      if (
        !rememberToggledState &&
        localStorage.getItem('Drupal.sticky_local_tasks.shown')
      ) {
        localStorage.removeItem('Drupal.sticky_local_tasks.shown');
      }

      if (savedState === 'true') {
        showStickyLocalTasksItems();
        toggle.classList.add('active');
        toggle.setAttribute('aria-expanded', 'true');
      } else {
        hideStickyLocalTasksItems(false); // no animation
        toggle.classList.remove('active');
        toggle.setAttribute('aria-expanded', 'false');
      }

      toggle.addEventListener('click', () => {
        const show = !items.classList.contains('show');

        if (show) {
          showStickyLocalTasksItems();
        } else {
          hideStickyLocalTasksItems();
        }

        if (rememberToggledState) {
          if (show) {
            localStorage.setItem('Drupal.sticky_local_tasks.shown', 'true');
          } else {
            localStorage.removeItem('Drupal.sticky_local_tasks.shown');
          }
        }

        toggle.classList.toggle('active', show);
        toggle.setAttribute('aria-expanded', show ? 'true' : 'false');
      });
    },
  };
})(Drupal, once);
