<?php

declare(strict_types=1);

namespace Drupal\Tests\sticky_local_tasks\Functional;

/**
 * Tests sticky local tasks when configured to be added to all pages.
 *
 * @group sticky_local_tasks
 */
class StickyLocalTasksHideDefaultTest extends StickyLocalTasksTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'olivero';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['sticky_local_tasks', 'node', 'block'];

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();
    $user = $this->drupalCreateUser([
      'administer site configuration',
      'bypass node access',
      'administer nodes',
      'administer users',
      'administer permissions',
    ]);
    $this->drupalLogin($user);
  }

  /**
   * Test hide and show default local tasks.
   */
  public function testDefaultLocalTasks(): void {

    $this->drupalGet($this->node->toUrl());
    $this->assertSession()->elementExists('xpath', '//link[contains(@href, "/sticky_local_tasks/assets/css/hide_default_local_tasks.css")]');

    $this->drupalGet('admin/config/user-interface/sticky-local-tasks');
    $this->getSession()->getPage()->uncheckField('usage_options[hide_default_local_tasks]');
    $this->getSession()->getPage()->pressButton('edit-submit');

    $this->drupalGet($this->node->toUrl());
    $this->assertSession()->elementNotExists('xpath', '//link[contains(@href, "/sticky_local_tasks/assets/css/hide_default_local_tasks.css")]');

  }

}
