/**
 * @file
 * Straker Translate target actions JS code for straker_translate target actions button.
 */

(function ($, once, Drupal) {
  'use strict';

  /**
   * Process paragraph_actions elements.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches straker_translateTargetActions behaviors.
   */
  Drupal.behaviors.straker_translateTargetActions = {
    attach: function (context, settings) {
      //var $actionsElement = $(context).find('.straker_translate-target-dropdown,.straker_translate-source-dropdown').once('straker_translate-target-dropdown');
      var $actionsElement = $(once('straker_translate-target-dropdown', '.straker_translate-target-dropdown,.straker_translate-source-dropdown', context));
      // Attach event handlers to toggle button.
      $actionsElement.each(function () {
        var $this = $(this);
        var $toggle = $this.find('.straker_translate-target-dropdown-toggle,.straker_translate-source-dropdown-toggle');

        $toggle.on('click', function (e) {
          e.preventDefault();
          $this.toggleClass('open');
        });

        $this.on('focusout', function (e) {
          setTimeout(function () {
            if ($this.has(document.activeElement).length == 0) {
              // The focus left the action button group, hide actions.
              $this.removeClass('open');
            }
          }, 1);
        });
      });
    },
  };
})(jQuery, once, Drupal);
