<?php

namespace Drupal\straker_translate\Controller;

use Drupal\straker_translate\Entity\StrakerTranslateProfile;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 *
 */
class StrakerTranslateBatchController extends StrakerTranslateControllerBase {

  /**
   *
   */
  public function dispatch($action, $entity_type, $entity_id) {
    /** @var \Drupal\straker_translate\StrakerTranslateContentTranslationServiceInterface $translation_service */
    $translation_service = \Drupal::service('straker_translate.content_translation');
    /** @var \Drupal\straker_translate\StrakerTranslateConfigurationServiceInterface $configuration_service */
    $configuration_service = \Drupal::service('straker_translate.configuration');
    /** @var \Drupal\straker_translate\Straker Translate $straker_translate */
    $straker_translate = \Drupal::service('straker_translate');

    $entity = \Drupal::entityTypeManager()->getStorage($entity_type)->load($entity_id);

    // This forces the hash to be set.
    if ($translation_service->hasEntityChanged($entity)) {
      $entity->save();
    }
    $profile = $configuration_service->getEntityProfile($entity, TRUE);

    switch ($action) {
      case 'uploadSingle':
        return $this->uploadSingle($entity_type, $entity_id, $profile);

      case 'downloadSingle':
        return $this->downloadSingle($entity_type, $entity_id, $profile);

      default:
        return $this->noAction();
    }
  }

  /**
   *
   */
  public function uploadSingle($entity_type, $entity_id, StrakerTranslateProfile $profile = NULL) {
    $batch = [
      'title' => $this->t('Uploading content to Straker Translate'),
      'operations' => $this->getUploadOperations($entity_type, [$entity_id]),
      'error_message' => t('An error happened.'),
      'finished' => 'straker_translate_operation_content_upload_finished',
      'file' => \Drupal::service('extension.list.module')->getPath('straker_translate') . '/straker_translate.batch.inc',
    ];
    $redirect_url = \Drupal::urlGenerator()->generate("entity.$entity_type.content_translation_overview",
      [$entity_type => $entity_id], UrlGeneratorInterface::ABSOLUTE_URL);
    batch_set($batch);
    return batch_process($redirect_url);
  }

  /**
   *
   */
  public function downloadSingle($entity_type, $entity_id, $locales) {
    $batch = [
      'title' => $this->t('Downloading translations from Straker Translate'),
      'operations' => $this->getDownloadOperations($entity_type, [$entity_id], $locales),
      'finished' => 'straker_translate_operation_content_download_finished',
      'file' => \Drupal::service('extension.list.module')->getPath('straker_translate') . '/straker_translate.batch.inc',
    ];
    $entity = \Drupal::entityTypeManager()->getStorage($entity_type)->load($entity_id);
    $redirect_url = \Drupal::urlGenerator()->generate("entity.$entity_type.content_translation_overview",
      [$entity_type => $entity_id], UrlGeneratorInterface::ABSOLUTE_URL);
    batch_set($batch);
    return batch_process($redirect_url);
  }

  /**
   *
   */
  public function checkUploadStatus($entity_type, $entity_id) {
    // @todo
  }

  /**
   *
   */
  public function checkTargetStatus($entity_type, $entity_id) {
    // @todo
  }

  /**
   *
   */
  public function addLanguageSingle($entity_type, $entity_id) {
    // @todo
  }

  /**
   *
   */
  protected function getUploadOperations($entity_type, $entity_ids) {
    $operations = [];
    if (is_array($entity_ids)) {
      foreach ($entity_ids as $id) {
        $operations[] = ['straker_translate_operation_content_upload', [$entity_type, $id]];
      }
    }
    return $operations;
  }

  /**
   *
   */
  protected function getDownloadOperations($entity_type, $entity_ids, $locales) {
    $operations = [];
    if (is_array($entity_ids)) {
      foreach ($entity_ids as $id) {
        foreach ($locales as $locale) {
          $operations[] = ['straker_translate_operation_translation_download', [$entity_type, $id, $locale]];
        }
      }
    }
    return $operations;
  }

  /**
   *
   */
  public function noAction() {
    $markup = $this->t('Straker Translate batch operation error: You must supply a valid action.');
    return [
      '#type' => 'markup',
      '#markup' => $markup,
    ];
  }

}
