<?php

namespace Drupal\straker_translate\Form;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\straker_translate\StrakerTranslateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a form to disconnect from  Straker Translate.
 */
class StrakerTranslateAccountDisconnectForm extends ConfirmFormBase {

  /**
   * A straker_translate connector object.
   *
   * @var \Drupal\straker_translate\StrakerTranslateInterface
   */
  protected $straker_translate;

  /**
   * Constructs a \Drupal\straker_translate\Form\StrakerTranslateAccountDisconnect object.
   *
   * @param \Drupal\straker_translate\StrakerTranslateInterface $straker_translate
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The factory for configuration objects.
   */
  public function __construct(StrakerTranslateInterface $straker_translate, ConfigFactoryInterface $config_factory) {
    $this->straker_translate = $straker_translate;
    $this->setConfigFactory($config_factory);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('straker_translate'),
      $container->get('config.factory')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'straker_translate_account_disconnect';
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to disconnect from Straker?');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Disconnect');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('straker_translate.settings');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->configFactory()->getEditable('straker_translate.account');
    $config->set('access_token', NULL);
    $config->set('login_id', NULL);
    $config->save();

    $this->logger('straker_translate')->notice('Account disconnected from  Straker Translate.');
    $this->messenger()->addStatus($this->t('You were disconnected from Straker.'));
    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
