<?php

namespace Drupal\straker_translate\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Configure text display settings for this page.
 */
class StrakerTranslateSettingsWorkflowsForm extends StrakerTranslateConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormID() {
    return 'straker_translate.setup_workflows_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $config = $this->configFactory->get('straker_translate.account');

    $workflow_id = $config->get('default.workflow');
    $workflows = $this->straker_translate->getWorkflows();

    $form['straker_translate_user_directions'] = [
      '#markup' => '<p>' . t('Your account is associated with multiple Straker Workflows.') . '</p>
        <p>' . t('Select the workflow that you would like associate with this site:') . '</p>',
    ];
    $workflow_options = [];
    foreach ($workflows as $id => $name) {
      $workflow_options[$id] = $name . ' (' . $id . ')';
    }
    asort($workflow_options);
    $form['workflow'] = [
      '#title'         => t('Workflow'),
      '#type'          => 'select',
      '#options'       => $workflow_options,
      '#default_value' => $workflow_id,
      '#required'      => TRUE,
    ];

    // Provide new button to continue.
    $form['actions']['submit']['#value'] = t('Next');

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $form_values = $form_state->getValues();
    $config = \Drupal::configFactory()->getEditable('straker_translate.account');
    $config->set('default.workflow', $form_values['workflow'])->save();
    // Update resources based on newly selected community.
    $form_state->setRedirect('straker_translate.manage');
    parent::submitForm($form, $form_state);
  }

}
