<?php

namespace Drupal\straker_translate\FormComponent;

use Drupal\Core\Entity\EntityInterface;

/**
 * Interface for Straker Translate form-field plugins.
 *
 * @package Drupal\straker_translate\FormComponent
 */
interface StrakerTranslateFormComponentFieldInterface extends StrakerTranslateFormComponentInterface {

  /**
   * Returns the table header for a field.
   *
   * @param string $entity_type_id
   *
   * @return mixed
   */
  public function getHeader($entity_type_id = NULL);

  /**
   * Returns the data for a field.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *
   * @return array
   */
  public function getData(EntityInterface $entity);

}
