<?php

namespace Drupal\straker_translate\FormComponent;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Manages Straker Translate form-field plugins.
 *
 * @package Drupal\straker_translate\FormComponent
 *
 * @see \Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFieldInterface
 * @see \Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFieldBase
 * @see \Drupal\straker_translate\Annotation\StrakerTranslateFormComponentField
 * @see \hook_straker_translate_form_field_alter()
 */
class StrakerTranslateFormComponentFieldManager extends StrakerTranslateFormComponentManagerBase {

  /**
   * FormComponentFieldManager constructor.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache.discovery service.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module_handler service.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/StrakerTranslateFormComponent/Field', $namespaces, $module_handler, 'Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFieldInterface', 'Drupal\straker_translate\Annotation\StrakerTranslateFormComponentField');

    $this->alterInfo('straker_translate_form_field');
    $this->setCacheBackend($cache_backend, 'straker_translate_form_field');
  }

}
