<?php

namespace Drupal\straker_translate;

/**
 *
 */
interface LanguageLocaleMapperInterface {

  /**
   * Gets the Drupal language for the given Straker Translate locale.
   *
   * @param string $locale
   *   The Straker Translate locale.
   *
   * @return \Drupal\language\ConfigurableLanguageInterface|null
   *   The Drupal language created for this locale, or NULL if there is none.
   */
  public function getConfigurableLanguageForLocale($locale);

  /**
   * Gets the Straker Translate locale for the given Drupal langcode.
   *
   * @param string $langcode
   *   The Drupal langcode.
   *
   * @return \Drupal\language\ConfigurableLanguageInterface|null
   *   The Straker Translate locale.
   */
  public function getLocaleForLangcode($langcode);

}
