<?php

namespace Drupal\straker_translate\Moderation;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Service for managing content moderation settings in the Straker Translate integration.
 *
 * @package Drupal\straker_translate\Moderation
 */
class StrakerTranslateContentModerationConfigurationService implements StrakerTranslateModerationConfigurationServiceInterface {

  use StrakerTranslateContentModerationCheckTrait;

  /**
   * The config factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new StrakerTranslateContentModerationConfigurationService object.
   *
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ModuleHandlerInterface $module_handler, ConfigFactoryInterface $config_factory) {
    $this->setModuleHandler($module_handler);
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public function getUploadStatus($entity_type_id, $bundle) {
    $config = $this->configFactory->get('straker_translate.settings');
    $upload_status = $config->get('translate.entity.' . $entity_type_id . '.' . $bundle . '.content_moderation.upload_status');
    return $upload_status;
  }

  /**
   * {@inheritdoc}
   */
  public function getDownloadTransition($entity_type_id, $bundle) {
    $config = $this->configFactory->get('straker_translate.settings');
    $download_transition = $config->get('translate.entity.' . $entity_type_id . '.' . $bundle . '.content_moderation.download_transition');
    return $download_transition;
  }

  /**
   * {@inheritdoc}
   */
  public function setUploadStatus($entity_type_id, $bundle, $status) {
    $config = $this->configFactory->getEditable('straker_translate.settings');
    $config->set('translate.entity.' . $entity_type_id . '.' . $bundle . '.content_moderation.upload_status', $status);
    $config->save();
    return $status;
  }

  /**
   * {@inheritdoc}
   */
  public function setDownloadTransition($entity_type_id, $bundle, $transition) {
    $config = $this->configFactory->getEditable('straker_translate.settings');
    $config->set('translate.entity.' . $entity_type_id . '.' . $bundle . '.content_moderation.download_transition', $transition);
    $config->save();
    return $transition;
  }

}
