<?php

namespace Drupal\straker_translate\Plugin\StrakerTranslateFormComponent\Field;

use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Entity\EntityInterface;
use Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFieldBase;

/**
 * Defines a Straker Translate form-field plugin for the translation profile.
 *
 * @StrakerTranslateFormComponentField(
 *   id = "profile",
 *   title = @Translation("Profile"),
 *   weight = 500,
 *   form_ids = {
 *     "straker_translate_management",
 *     "straker_translate_entity_management",
 *     "straker_translate_job_content_entities_management"
 *   }
 * )
 */
class Profile extends StrakerTranslateFormComponentFieldBase {

  use DependencySerializationTrait;

  /**
   * {@inheritdoc}
   */
  public function getData(EntityInterface $entity) {
    if ($this->straker_translateConfiguration->isEnabled($entity->getEntityTypeId(), $entity->bundle())) {
      if ($profile = $this->straker_translateConfiguration->getEntityProfile($entity, TRUE)) {
        return $profile->label();
      }

      return '';
    }

    return $this->t('Not enabled');
  }

}
