<?php

namespace Drupal\straker_translate\Plugin\StrakerTranslateFormComponent\Filter;

use Drupal\Core\Database\Query\SelectInterface;
use Drupal\straker_translate\StrakerTranslate;
use Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFilterBase;

/**
 * Defines a Straker Translate form-filter plugin for the target status.
 *
 * @StrakerTranslateFormComponentFilter(
 *   id = "target_status",
 *   title = @Translation("Target status"),
 *   form_ids = {
 *     "straker_translate_management",
 *   },
 *   weight = 800,
 *   group = @Translation("Advanced options"),
 * )
 */
class TargetStatus extends StrakerTranslateFormComponentFilterBase {

  /**
   * {@inheritdoc}
   */
  public function buildElement($default_value = NULL) {
    return [
      '#type' => 'select',
      '#title' => $this->getTitle(),
      '#default_value' => $default_value ?? '',
      '#options' => [
        '' => $this->t('All'),
        StrakerTranslate::STATUS_CURRENT => $this->t('Current'),
        StrakerTranslate::STATUS_EDITED => $this->t('Edited'),
        StrakerTranslate::STATUS_PENDING => $this->t('In Progress'),
        StrakerTranslate::STATUS_READY => $this->t('Ready'),
        StrakerTranslate::STATUS_INTERMEDIATE => $this->t('Interim'),
        StrakerTranslate::STATUS_REQUEST => $this->t('Not Requested'),
        StrakerTranslate::STATUS_CANCELLED => $this->t('Cancelled'),
        StrakerTranslate::STATUS_ERROR => $this->t('Error'),
        StrakerTranslate::STATUS_LOCKED => $this->t('Locked'),
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function filter(string $entity_type_id, array $entities, $value, SelectInterface &$query = NULL) {
    parent::filter($entity_type_id, $entities, $value, $query);

    $entity_type = $this->getEntityType($entity_type_id);
    $id_key = $entity_type->getKey('id');
    $langcode_key = $entity_type->getKey('langcode');
    $base_table = $entity_type->getBaseTable();
    $metadata_type = $this->entityTypeManager->getDefinition('straker_content_metadata');
    $metadata_type_base_table = $metadata_type->getBaseTable();
    /** @var \Drupal\Core\Database\Query\PagerSelectExtender $subquery */
    $subquery = $this->connection->select($base_table, 'entity_table')->extend('\Drupal\Core\Database\Query\PagerSelectExtender');
    $subquery->fields('entity_table', [$id_key]);
    $subquery->innerJoin($metadata_type_base_table, 'metadata_target', 'entity_table.' . $id_key . '= metadata_target.content_entity_id AND metadata_target.content_entity_type_id = \'' . $entity_type_id . '\'');
    $subquery->innerJoin('straker_content_metadata__translation_status', 'translation_target_status', 'metadata_target.id = translation_target_status.entity_id AND translation_target_status.translation_status_language <> entity_table.' . $langcode_key);
    $subquery->condition('translation_target_status.translation_status_value', $value);

    $query->condition('entity_table.' . $id_key, $subquery, 'IN');

    if ($unions = $query->getUnion()) {
      foreach ($unions as $union) {
        $union['query']->condition('entity_table.' . $id_key, $subquery, 'IN');
      }
    }
  }

}
