<?php

namespace Drupal\straker_translate;

/**
 * Service contract for checking Straker Translate profile usage.
 *
 * @package Drupal\straker_translate
 */
interface StrakerTranslateProfileUsageInterface {

  /**
   * Bit flag constant for profiles configured to be used by content entities.
   */
  const USED_BY_SETTINGS = 4;

  /**
   * Bit flag constant for unused profiles.
   */
  const UNUSED = 0;

  /**
   * Bit flag constant for profiles configured to be used by config entities.
   */
  const USED_BY_CONFIG = 2;

  /**
   * Bit flag constant for profiles assigned to content.
   */
  const USED_BY_CONTENT = 1;

  /**
   * Check if a profile is used by content entities.
   *
   * @param \Drupal\straker_translate\StrakerTranslateProfileInterface $profile
   *   The profile being checked.
   *
   * @return int
   *   Bitwise flag. Can include StrakerTranslateProfileUsageInterface::USED_BY_CONTENT
   *   or StrakerTranslateProfileUsageInterface::UNUSED.
   */
  public function isUsedByContent(StrakerTranslateProfileInterface $profile);

  /**
   * Check if a profile is configured to be used by config entities.
   *
   * @param \Drupal\straker_translate\StrakerTranslateProfileInterface $profile
   *   The profile being checked.
   *
   * @return int
   *   Bitwise flag. Can include StrakerTranslateProfileUsageInterface::USED_BY_CONFIG or
   *   StrakerTranslateProfileUsageInterface::UNUSED.
   */
  public function isUsedByConfig(StrakerTranslateProfileInterface $profile);

  /**
   * Check if a profile is configured to be used by content entities.
   *
   * @param \Drupal\straker_translate\StrakerTranslateProfileInterface $profile
   *   The profile being checked.
   *
   * @return int
   *   Bitwise flag. Can include StrakerTranslateProfileUsageInterface::USED_BY_SETTINGS
   *   or StrakerTranslateProfileUsageInterface::UNUSED.
   */
  public function isUsedByContentSettings(StrakerTranslateProfileInterface $profile);

}
