<?php

namespace Drupal\straker_translate;

/**
 * Useful methods for checking if Straker Translate is already setup.
 */
trait StrakerTranslateSetupTrait {

  /**
   * A straker_translate connector object.
   *
   * @var \Drupal\straker_translate\StrakerTranslateInterface
   */
  protected $straker_translate;

  /**
   * Straker the Straker translation module has been properly initialized.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse|false
   *   A redirect response object, or FALSE if setup is complete.
   */
  protected function checkSetup() {
    if (!$this->setupCompleted()) {
      return $this->redirect('straker_translate.setup_account');
    }
    return FALSE;
  }

  /**
   * Checks if Straker Translate module is completely set up.
   *
   * @return boolean TRUE if connected, FALSE otherwise.
   */
  public function setupCompleted() {
    $accountConfig = $this->config('straker_translate.account');
    $accessToken = $accountConfig->get('access_token');
    if (!empty($accessToken)) {
      return TRUE;
    }
    return FALSE;
  }

}
