<?php

/**
 * @file
 * Drush 8 integration for Straker Translate.
 */

use Drupal\straker_translate\Cli\Commands\Drush8\Drush8IoWrapper;

/**
 * Implements hook_drush_command().
 */
function straker_translate_drush_command() {

  $commands['straker_translate-upload'] = [
    'description' => 'Upload content to Straker Translate.',
    'aliases' => ['ltk-upload'],
    'arguments' => [
      'entity_type_id' => 'The entity type ID. E.g. "node"',
      'entity_id' => 'The entity ID. E.g. "2',
    ],
    'required-arguments' => TRUE,
    'examples' => [
      'drush ltk-upload node 1' => 'Upload node with ID 1.',
      'drush ltk-upload taxonomy_term 3',
    ],
    'category' => 'Straker translation',
  ];
  $commands['straker_translate-check-upload'] = [
    'description' => 'Check upload status to Straker Translate.',
    'aliases' => ['ltk-source'],
    'arguments' => [
      'entity_type_id' => 'The entity type ID. E.g. "node"',
      'entity_id' => 'The entity ID. E.g. "2"',
    ],
    'required-arguments' => TRUE,
    'examples' => [
      'drush ltk-check-upload node 1' => 'Check upload status for node with ID 1.',
      'drush ltk-check-upload taxonomy_term 3' => 'Check upload status for taxonomy term with ID 3.',
    ],
    'category' => 'Straker translation',
  ];
  $commands['straker_translate-download-translations'] = [
    'description' => 'Download translations from Straker Translate.',
    'aliases' => ['ltk-download'],
    'arguments' => [
      'entity_type_id' => 'The entity type ID. E.g. "node"',
      'entity_id' => 'The entity ID. E.g. "2"',
    ],
    'options' => [
      'langcodes' => 'A comma delimited list of language codes.',
    ],
    'required-arguments' => TRUE,
    'examples' => [
      'drush ltk-download node 1' => 'Download translations for node with ID 1.',
      'drush ltk-download taxonomy_term 3 --langcodes=es,it' => 'Download Spanish and Italian translations for taxonomy term with ID 3.',
    ],
    'category' => 'Straker translation',
  ];

  return $commands;
}

/**
 *
 */
function drush_straker_translate_upload($entity_type_id, $entity_id) {
  print('<pre>');print_r("drush inc file");print('</pre>');exit;
  $facade = new Drush8IoWrapper();
  /** @var \Drupal\straker_translate\Cli\StrakerTranslateCliService $cliService */
  $cliService = \Drupal::service('straker_translate.cli_service');
  $cliService->setupOutput($facade);
  $cliService->setLogger($facade);

  return $cliService->upload($entity_type_id, $entity_id);
}

/**
 *
 */
function drush_straker_translate_check_upload($entity_type_id, $entity_id) {
  $facade = new Drush8IoWrapper();
  /** @var \Drupal\straker_translate\Cli\StrakerTranslateCliService $cliService */
  $cliService = \Drupal::service('straker_translate.cli_service');
  $cliService->setupOutput($facade);
  $cliService->setLogger($facade);

  return $cliService->checkUpload($entity_type_id, $entity_id);
}

/**
 *
 */
function drush_straker_translate_download_translations($entity_type_id, $entity_id) {
  $facade = new Drush8IoWrapper();
  /** @var \Drupal\straker_translate\Cli\StrakerTranslateCliService $cliService */
  $cliService = \Drupal::service('straker_translate.cli_service');
  $cliService->setupOutput($facade);
  $cliService->setLogger($facade);

  $langcodes = _convert_csv_to_array(drush_get_option('langcodes', 'all'));

  return $cliService->downloadTranslations($entity_type_id, $entity_id, $langcodes);
}
