<?php

namespace Drupal\Tests\lingotek\Unit\Form;

use Drupal\Core\Config\Config;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Routing\UrlGeneratorInterface;
use Drupal\Core\Utility\LinkGeneratorInterface;
use Drupal\lingotek\Form\LingotekSettingsConnectForm;
use Drupal\lingotek\LingotekInterface;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\lingotek\Form\LingotekSettingsConnectForm
 * @group lingotek
 * @preserveGlobalState disabled
 */
class LingotekSettingsConnectFormTest extends UnitTestCase {

  /**
   * The Lingotek service
   *
   * @var \Drupal\lingotek\LingotekInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $lingotek;

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $configFactory;

  /**
   * The Lingotek Filter manager.
   *
   * @var \Drupal\lingotek\LingotekFilterManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $lingotekFilterManager;

  /**
   * The url generator.
   *
   * @var \Drupal\Core\Routing\UrlGeneratorInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $urlGenerator;

  /**
   * The link generator.
   *
   * @var \Drupal\Core\Utility\LinkGeneratorInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $linkGenerator;

  /**
   * @var \Drupal\lingotek\Form\LingotekSettingsTabAccountForm
   */
  protected $form;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->lingotek = $this->createMock(LingotekInterface::class);
    $this->configFactory = $this->createMock(ConfigFactoryInterface::class);
    $this->urlGenerator = $this->createMock(UrlGeneratorInterface::class);
    $this->linkGenerator = $this->createMock(LinkGeneratorInterface::class);
    $messenger = $this->createMock(MessengerInterface::class);

    $this->form = new LingotekSettingsConnectForm(
      $this->lingotek,
      $this->configFactory,
      $this->urlGenerator,
      $this->linkGenerator
    );
    $this->form->setStringTranslation($this->getStringTranslationStub());
    $this->form->setMessenger($messenger);
  }

  /**
   * @covers ::getFormId
   */
  public function testGetFormId() {
    $form_id = $this->form->getFormID();
    $this->assertSame('lingotek.connect_form', $form_id);
  }

  /**
   * @covers ::buildForm
   */
  public function testBuildForm() {
    $config = $this->createMock(Config::class);
    $config->expects($this->any())
      ->method('get')
      ->willReturnMap([
        ['login_id', 'test@example.com'],
        ['access_token', 'ef4b4d69-5be2-4513-b4f1-7e0f6f9511a0'],
        ['default_client_id', 'my-client-id'],
        ['host', 'http://example.com'],
      ]);
    $this->configFactory->expects($this->once())
      ->method('get')
      ->with('lingotek.account')
      ->willReturn($config);

    $this->urlGenerator->expects($this->once())
      ->method('generateFromRoute')
      ->with('lingotek.access_token_update')
      ->willReturn('http://example.com/access-token-update');

    $build = [];
    $form_state = $this->createMock(FormStateInterface::class);
    $build = $this->form->buildForm($build, $form_state);
    $this->assertSame('http://example.com/access-token-update',
      $build['account_types']['existing_account']['cta']['#url']->getUri());
  }

}
