<?php

namespace Drupal\straker_translate\Controller;

use Drupal\Component\Serialization\Json;
use Drupal\Core\Form\FormState;
use Drupal\Core\Url;
use Drupal\straker_translate\Form\StrakerTranslateSettingsTabAccountForm;
use Drupal\straker_translate\Form\StrakerTranslateSettingsTabConfigurationForm;
use Drupal\straker_translate\Form\StrakerTranslateSettingsTabContentForm;
use Drupal\straker_translate\Form\StrakerTranslateSettingsTabIntegrationsForm;
use Drupal\straker_translate\Form\StrakerTranslateSettingsTabPreferencesForm;
use Drupal\straker_translate\Form\StrakerTranslateSettingsTabProfilesEditForm;
use Drupal\straker_translate\Form\StrakerTranslateSettingsTabUtilitiesForm;

/**
 *
 */
class StrakerTranslateSettingsController extends StrakerTranslateControllerBase {

  /**
   *
   */
  public function content() {
    if ($redirect = $this->checkSetup()) {
      return $redirect;
    }

    $settings_tab = [
      $this->formBuilder->getForm(StrakerTranslateSettingsTabAccountForm::class),
      $this->formBuilder->getForm(StrakerTranslateSettingsTabContentForm::class),
      $this->formBuilder->getForm(StrakerTranslateSettingsTabConfigurationForm::class),
      $this->getProfileListForm(),
      $this->formBuilder->getForm(StrakerTranslateSettingsTabPreferencesForm::class),
      $this->getIntegrationsSettingsForm(),
      $this->formBuilder->getForm(StrakerTranslateSettingsTabUtilitiesForm::class),
    ];

    return $settings_tab;
  }

  /**
   * Gets the profile list form wrapped, so it can be expanded and collapsed.
   *
   * @return array
   *   The form definition.
   */
  public function getProfileListForm() {
    $list = $this->entityTypeManager()->getListBuilder('straker_translate_profile');
    $original_form = $this->formBuilder->getForm($this->entityTypeManager()->getListBuilder('straker_translate_profile'), new FormState());
    $form['profiles_wrapper'] = [
      '#type' => 'details',
      '#title' => $this->t('Translation Profiles'),
    ];
    $form['profiles_wrapper']['form'] = $original_form;
    // We add the link manually, as we cannot use local actions for that.
    $form['profiles_wrapper']['form']['add_link'] = [
      '#type' => 'link',
      '#title' => t('Add new Translation Profile'),
      '#url' => Url::fromRoute('entity.straker_translate_profile.add_form'),
      '#weight' => 50,
      '#attributes' => [
        'class' => ['use-ajax'],
        'data-dialog-type' => 'modal',
        'data-dialog-options' => Json::encode([
          'width' => 900,
          'height' => 800,
        ]),
      ],
    ];

    return $form;
  }

  /**
   *
   */
  public function getIntegrationsSettingsForm() {
    $original_form = $this->formBuilder->getForm(StrakerTranslateSettingsTabIntegrationsForm::class);

    if (isset($original_form['contrib'])) {
      $form['integrations_wrapper'] = [
        '#type' => 'details',
        '#title' => $this->t('Integrations Settings'),
      ];
      $form['integrations_wrapper']['form'] = $original_form;
      return $form;
    }
    else {
      return NULL;
    }
  }

  /**
   *
   */
  public function profileForm() {
    if ($redirect = $this->checkSetup()) {
      return $redirect;
    }

    $profiles_modal = [
      $this->formBuilder->getForm(StrakerTranslateSettingsTabProfilesEditForm::class),
    ];

    return $profiles_modal;
  }

}
