<?php

namespace Drupal\straker_translate\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\straker_translate\StrakerTranslateInterfaceTranslationServiceInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a form to disconnect from Straker Translate.
 */
class StrakerTranslateInterfaceTranslationClearMetadataForm extends ConfirmFormBase {

  /**
   * The Straker Translate interface translation service.
   *
   * @var \Drupal\straker_translate\StrakerTranslateInterfaceTranslationServiceInterface
   */
  protected $straker_translateInterfaceTranslation;

  /**
   * Constructs a StrakerTranslateInterfaceTranslationClearMetadataForm object.
   *
   * @param \Drupal\straker_translate\StrakerTranslateInterfaceTranslationServiceInterface $straker_translate_interface_translation
   *   The Straker Translate interface translation service.
   */
  public function __construct(StrakerTranslateInterfaceTranslationServiceInterface $straker_translate_interface_translation) {
    $this->straker_translateInterfaceTranslation = $straker_translate_interface_translation;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('straker_translate.interface_translation')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'straker_translate_interface_translation_clear_metadata_form';
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to clear the Straker metadata?');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->t("This will remove the metadata stored about your Straker Translate interface translations, so you will need to re-upload those in case you want to translate them. This operation won't remove any interface translations from your Drupal site.") . ' ' . $this->t('This action cannot be undone.');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Clear metadata');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('straker_translate.manage_interface_translation');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->straker_translateInterfaceTranslation->deleteAllMetadata();

    $this->logger('straker_translate')->notice('Cleared interface translation Straker Translate metadata.');
    $this->messenger()->addStatus($this->t('You have cleared the Straker Translate metadata for interface translations.'));
    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
