<?php

namespace Drupal\straker_translate\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for straker_translate profiles edition.
 */
class StrakerTranslateProfileEditForm extends StrakerTranslateProfileFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'straker_translate_profile_edit_form';
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $return = parent::save($form, $form_state);
    $this->messenger()->addStatus($this->t('The Straker Translate profile has been successfully edited.'));
    $form_state->setRedirect('straker_translate.settings');
    return $return;
  }

}
