<?php

namespace Drupal\straker_translate\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Straker Translate.
 */
class StrakerTranslateSettingsAccountForm extends StrakerTranslateConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormID() {
    return 'straker_translate.account_form';
  }

  /**
   * * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $form = parent::buildForm($form, $form_state);
    $accountConfig = $this->config('straker_translate.account');

    $form['account']['connected'] = [];
    $form['account']['access_token'] = [
      '#type'        => 'textfield',
      '#title'       => t('Access Token'),
      '#description' => t('Place the new access token here.'),
      '#value'       => $accountConfig->get('access_token'),
      '#disabled'    => TRUE,
    ];

    // Provide new button to continue.
    $form['actions']['submit']['#value'] = t('Next');

    return $form;

  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Everything is saved in the previous step, so redirect to community form.
    $form_state->setRedirect('straker_translate.manage');
  }

}
