<?php

namespace Drupal\straker_translate\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Configure  Straker Translate.
 */
class StrakerTranslateSettingsConnectForm extends StrakerTranslateConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'straker_translate.connect_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Build the redirecting link for authentication to  Straker Translate.
    $accountConfig = $this->configFactory->get('straker_translate.account');
    $host = $accountConfig->get('host');

    $straker_translate_register_link = 'https://insight.strakertranslations.com/straker_translate-freemium-upgrade-connectors';
    $update_accesss_token = $this->urlGenerator->generateFromRoute('straker_translate.access_token_update', [], ['absolute' => TRUE]);
    $straker_translate_demo_link = 'https://www.straker_translate.com/request-demo';

    $form = [];
    $form['intro_title'] = [
      '#prefix' => '<h1>',
      '#markup' => $this->t('Straker Translate'),
      '#suffix' => '</h1>',
    ];
    $form['intro_paragraph'] = [
      '#prefix' => '<p>',
      '#markup' => $this->t('Straker Translate is an AI-powered platform for businesses to quickly translate content, check translation quality, and request human review—all in one self-serve solution. It provides a complete translation management system with a suite of powerful AI tools to handle all your content needs.'),
      '#suffix' => '</p>',
    ];

    $form['account_types'] = [
      '#type' => 'container',
      '#attributes' => ['class' => 'straker_translate_signup_types'],
    ];

    $form['account_types']['existing_account'] = [
      '#type' => 'container',
      '#attributes' => ['class' => 'straker_translate_signup_box'],
    ];
    $form['account_types']['existing_account']['title'] = [
      '#prefix' => '<h3>',
      '#markup' => $this->t('Connect existing account'),
      '#suffix' => '</h3>',
    ];
    $form['account_types']['existing_account']['body'] = [
      '#prefix' => '<div class="straker_translate_signup_box_main">',
      '#markup' => $this->t('Retrieve or update access token'),
      '#suffix' => '</div>',
    ];

    $form['account_types']['existing_account']['cta'] = [
      '#type' => 'link',
      '#title' => $this->t('Setup Token'),
      '#url' => Url::fromUri($update_accesss_token),
      '#attributes' => ['class' => ['straker_translate_signup_box_cta', 'straker_translate_signup_box_main_cta']],
    ];

    $form['#attributes']['class'][] = 'straker_translate_signup';
    $form['#attached']['library'][] = 'straker_translate/straker_translate.signup';

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Do nothing for now.
  }

}
