<?php

namespace Drupal\straker_translate\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Configure text display settings for this page.
 */
class StrakerTranslateSettingsDefaultsForm extends StrakerTranslateConfigFormBase {
  protected $defaults_labels = [];
  protected $defaults;
  protected $resources;

  /**
   *
   */
  public function init() {
    $config = \Drupal::configFactory()->getEditable('straker_translate.account');

    $this->defaults = $config->get('default');
    $this->resources = $this->straker_translate->getResources();

    // Make visible only those options that have more than one choice.
    if (count($this->resources['workflow']) > 1) {
      $this->defaults_labels['workflow'] = t('Default Workflow');
    }
    elseif (count($this->resources['workflow']) == 1) {
      $config->set('default.workflow', current(array_keys($this->resources['workflow'])));
    }

    // Set workflow to machine translation every time regardless if there's more than one choice.
    $machine_translation = array_search('Machine Translation', $this->resources['workflow']);
    if ($machine_translation) {
      $config->set('default.workflow', $machine_translation);
    }
    $config->save();
  }

  /**
   * {@inheritdoc}
   */
  public function getFormID() {
    return 'straker_translate.settings_defaults';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $this->init();

    foreach ($this->defaults_labels as $key => $label) {
      $options = $this->resources['workflow'];
      $form[$key] = [
        '#title' => $label,
        '#type' => 'select',
        '#options' => $options,
        '#required' => TRUE,
      ];
      if (isset($this->defaults[$key])) {
        $form[$key]['#default_value'] = $this->defaults[$key];
      }
    }

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->configFactory()->getEditable('straker_translate.account');
    $form_values = $form_state->getValues();
    foreach ($this->defaults_labels as $key => $label) {
      $config->set('default.' . $key, $form_values[$key]);
    }
    $config->save();

    $form_state->setRedirect('straker_translate.manage');
    parent::submitForm($form, $form_state);
  }

}
