<?php

namespace Drupal\straker_translate\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Form for editing defaults.
 */
class StrakerTranslateSettingsEditDefaultsForm extends StrakerTranslateSettingsDefaultsForm {

  /**
   * {@inheritDoc}
   */
  public function init() {
    $this->defaults_labels['workflow'] = t('Default Workflow');

    $config = \Drupal::configFactory()->getEditable('straker_translate.account');
    $this->defaults = $config->get('default');
    $this->resources = $this->straker_translate->getResources();
  }

  /**
   * {@inheritDoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // When editing, we redirect to the account form, and we don't notify
    // about callback url.
    $config = $this->configFactory()->getEditable('straker_translate.account');
    $form_values = $form_state->getValues();
    foreach ($this->defaults_labels as $key => $label) {
      $config->set('default.' . $key, $form_values[$key]);
    }
    $config->save();

    $form_state->setRedirect('straker_translate.settings');
    $this->messenger()->addStatus($this->t('The configuration options have been saved.'));
  }

}
