<?php

namespace Drupal\straker_translate\FormComponent;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Manages Straker Translate form-filter plugins.
 *
 * @see \Drupal\straker_translate\FormComponent\FormComponentBulkActionInterface
 * @see \Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentBulkActionBase
 * @see \Drupal\straker_translate\Annotation\StrakerTranslateFormComponentBulkAction
 * @see \hook_straker_translate_form_bulk_action_alter()
 */
class StrakerTranslateFormComponentBulkActionOptionManager extends StrakerTranslateFormComponentManagerBase {

  /**
   * StrakerTranslateFormComponentBulkActionOptionManager constructor.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache.discovery service.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module_handler service.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/StrakerTranslateFormComponent/BulkActionOption', $namespaces, $module_handler, 'Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentBulkActionOptionInterface', 'Drupal\straker_translate\Annotation\StrakerTranslateFormComponentBulkActionOption');

    $this->alterInfo('straker_translate_form_bulk_action_option');
    $this->setCacheBackend($cache_backend, 'straker_translate_form_bulk_action_option');
  }

  /**
   *
   */
  public function getOptions() {
    $options = [];
    $definitions = $this->getDefinitions();
    foreach ($definitions as $plugin_id => $definition) {
      $options[$plugin_id] = $this->createInstance($plugin_id);
    }
    return $options;
  }

}
