<?php

namespace Drupal\straker_translate\FormComponent;

/**
 * Base class for Straker Translate form-field plugins.
 *
 * @package Drupal\straker_translate\FormComponent
 */
abstract class StrakerTranslateFormComponentFieldBase extends StrakerTranslateFormComponentBase implements StrakerTranslateFormComponentFieldInterface {

  /**
   * {@inheritdoc}
   */
  public function getHeader($entity_type_id = NULL) {
    return $this->getPluginDefinition()['title'];
  }

  /**
   * Provides sort parameters for the header.
   *
   * @param string $entity_type_id
   *   The entity-type ID.
   *
   * @return array
   *   An array of sort parameters:
   *   - field: the field by which the query will be sorted,
   *     e.g. 'entity_data.nid'.
   *   - sort (optional): the sort direction. Defaults to 'asc'.
   */
  protected function sort($entity_type_id) {
    return [];
  }

}
