<?php

namespace Drupal\straker_translate\FormComponent;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Manages Straker Translate form-filter plugins.
 *
 * @see \Drupal\straker_translate\FormComponent\FormComponentFilterInterface
 * @see \Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFilterBase
 * @see \Drupal\straker_translate\Annotation\StrakerTranslateFormComponentFilter
 * @see \hook_straker_translate_form_filter_alter()
 */
class StrakerTranslateFormComponentFilterManager extends StrakerTranslateFormComponentManagerBase {

  /**
   * FormComponentFilterManager constructor.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache.discovery service.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module_handler service.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/StrakerTranslateFormComponent/Filter', $namespaces, $module_handler, 'Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFilterInterface', 'Drupal\straker_translate\Annotation\StrakerTranslateFormComponentFilter');

    $this->alterInfo('straker_translate_form_filter');
    $this->setCacheBackend($cache_backend, 'straker_translate_form_filter');
  }

}
