<?php

namespace Drupal\straker_translate\Moderation;

/**
 * A facade for getting the services that are part of moderation integrations.
 *
 * @package Drupal\straker_translate\Moderation
 */
interface StrakerTranslateModerationFactoryInterface {

  /**
   * Called when the tag collector finds a moderation configuration service.
   *
   * @param \Drupal\straker_translate\Moderation\StrakerTranslateModerationConfigurationServiceInterface $service
   *   The moderation configuration service.
   * @param string $id
   *   The id of the tagged service.
   * @param int $priority
   *   The priority for the tagged service.
   */
  public function addModerationConfiguration(StrakerTranslateModerationConfigurationServiceInterface $service, $id, $priority);

  /**
   * Called when the tag collector finds a moderation settings form service.
   *
   * @param \Drupal\straker_translate\Moderation\StrakerTranslateModerationSettingsFormInterface $service
   *   The moderation configuration service.
   * @param string $id
   *   The id of the tagged service.
   * @param int $priority
   *   The priority for the tagged service.
   */
  public function addModerationForm(StrakerTranslateModerationSettingsFormInterface $service, $id, $priority);

  /**
   * Called when the tag collector finds a moderation handler service.
   *
   * @param \Drupal\straker_translate\Moderation\StrakerTranslateModerationHandlerInterface $service
   *   The moderation configuration service.
   * @param string $id
   *   The id of the tagged service.
   * @param int $priority
   *   The priority for the tagged service.
   */
  public function addModerationHandler(StrakerTranslateModerationHandlerInterface $service, $id, $priority);

  /**
   * Gets the first moderation configuration service applying to a given entity.
   *
   * @return \Drupal\straker_translate\Moderation\StrakerTranslateModerationConfigurationServiceInterface
   *   The moderation configuration service.
   */
  public function getModerationConfigurationService();

  /**
   * Gets the first moderation settings form service applying to a given entity.
   *
   * @return \Drupal\straker_translate\Moderation\StrakerTranslateModerationSettingsFormInterface
   *   The moderation settings form service.
   */
  public function getModerationSettingsForm();

  /**
   * Gets the first moderation handler service that applies to the given entity.
   *
   * @return \Drupal\straker_translate\Moderation\StrakerTranslateModerationHandlerInterface
   *   The moderation handler service.
   */
  public function getModerationHandler();

}
