<?php

namespace Drupal\straker_translate\Plugin\StrakerTranslateFormComponent\BulkAction\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\straker_translate\StrakerTranslateConfigurationServiceInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 *
 */
class ProfileStrakerTranslateBulkActionDeriver extends DeriverBase implements ContainerDeriverInterface {

  /**
   * The Straker Translate configuration service.
   *
   * @var \Drupal\straker_translate\StrakerTranslateConfigurationServiceInterface
   */
  protected $straker_translateConfiguration;

  /**
   * @param \Drupal\straker_translate\StrakerTranslateConfigurationServiceInterface $straker_translate_configuration
   *   The Straker Translate configuration service.
   */
  public function __construct(StrakerTranslateConfigurationServiceInterface $straker_translate_configuration) {
    $this->straker_translateConfiguration = $straker_translate_configuration;
  }

  /**
   * @{inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('straker_translate.configuration')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $definitions = parent::getDerivativeDefinitions($base_plugin_definition);
    if (empty($definitions)) {
      $plugin_derivatives = [];
      $profiles = $this->straker_translateConfiguration->getProfileOptions();
      foreach ($profiles as $profile_id => $profile) {
        $plugin_derivatives[$profile_id] = [
          'profile' => $profile,
          'profile_id' => $profile_id,
        ] + $base_plugin_definition;
      }
      $this->derivatives = $plugin_derivatives;
    }
    return parent::getDerivativeDefinitions($base_plugin_definition);
  }

}
