<?php

namespace Drupal\straker_translate\Plugin\StrakerTranslateFormComponent\Field;

use Drupal\Core\Entity\EntityInterface;
use Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentBundleTrait;
use Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFieldBase;

/**
 * Defines a Straker Translate form-field plugin for an entity's content type.
 *
 * @StrakerTranslateFormComponentField(
 *   id = "content_type",
 *   title = @Translation("Content type"),
 *   weight = 50,
 *   form_ids = {
 *     "straker_translate_job_content_entities_management"
 *   }
 * )
 */
class ContentType extends StrakerTranslateFormComponentFieldBase {

  use StrakerTranslateFormComponentBundleTrait;

  /**
   * {@inheritdoc}
   */
  public function isApplicable(array $arguments = []) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function getHeader($entity_type_id = NULL) {
    return $this->t('Content Type');
  }

  /**
   * {@inheritdoc}
   */
  public function getData(EntityInterface $entity) {
    return $entity->getEntityType()->getLabel();
  }

}
