<?php

namespace Drupal\straker_translate\Plugin\StrakerTranslateFormComponent\Field;

use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Entity\EntityInterface;
use Drupal\straker_translate\StrakerTranslate;
use Drupal\straker_translate\FormComponent\StrakerTranslateFormComponentFieldBase;

/**
 * Defines a Straker Translate form-field plugin for a translation's source status.
 *
 * @StrakerTranslateFormComponentField(
 *   id = "source",
 *   title = @Translation("Source"),
 *   weight = 300,
 *   form_ids = {
 *     "straker_translate_management",
 *     "straker_translate_entity_management",
 *     "straker_translate_job_content_entities_management"
 *   }
 * )
 */
class Source extends StrakerTranslateFormComponentFieldBase {

  use DependencySerializationTrait;

  /**
   * {@inheritdoc}
   */
  public function getData(EntityInterface $entity) {
    $language = $entity->getUntranslated()->language();
    // Return just the language name without any styling or dropdown
    return [
      'data' => [
        '#markup' => $language->getName(),
      ],
    ];
  }

}
